/*

 MemoryBlock Class for C++
 (c) 2004 Jonathan Bettencourt / Kreative Korporation

 This is the first thing I've written for C++ outside of a Hello World program,
 so please be patient with my possibly inefficient coding.
 (Such an odd thing to start out with, something this advanced, don't you think?
 I think it's good that I'm doing this, to get a feel for memory management.)


 This basically imitates the MemoryBlock class found in RealBasic. You create
 a memoryblock of a specified size, which becomes your block of memory to do with
 as you please. You can read and write values of different data types from any
 memory location in the memoryblock. You can also change the size later, if you
 want. Memoryblock is (or at least should be) clean, handling all of the memory
 management for you and never leaving the possibility of losing track of it all.

 There are two sets of get/set functions. One set is named like the C++ data types
 and accepts and returns specific types. The other set is named like the properties
 of a RealBasic MemoryBlock and use just one data type for a general data type,
 regardless of size (int for all integers, double for all real numbers, char* for
 all strings, etc.).

 The setting of the littleEndian flag only affects the following:

	get/setLong
	get/setShort
	get/setUShort

 This class does no bounds checking. Come to think of it, I don't think the
 RealBasic version does bounds checking either.


 This code is under the MIT license.

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef _____MEMORYBLOCK_____
#define _____MEMORYBLOCK_____

#include <string>
using namespace std;

class memoryblock
{
	public:

	bool littleEndian;

	memoryblock(void); /* default constructor; do this to make sure nothing weird happens */
	memoryblock(int size); /* basic constructor */
	memoryblock(const memoryblock&); /* copier */
	~memoryblock(void); /* destructor */
	const memoryblock& operator = (const memoryblock&); /* assignment */

	void zeroOut(void);
	void zeroOut(int);
	void zeroOut(int, int);

	int getSize(void);
	void setSize(int);
	const char * getPtr(void);

	void setLittleEndian(void);
	void setBigEndian(void);
	void setMotorola(void);
	void setIntel(void);
	void setDefaultEndianness(void);

	/* REALBASIC-LIKE GET/SET FUNCTIONS */
	bool getBooleanValue(int);
	int getByte(int);
	char * getCString(int);
	string getCStringAsString(int);
	double getDoubleValue(int);
	int getLong(int);
	char * getPString(int);
	char * getPStringAsCString(int);
	string getPStringAsString(int);
	int getShort(int);
	double getSingleValue(int);
	char * getStringValue(int, int);
	char * getStringValueAsCString(int, int);
	string getStringValueAsString(int, int);
	int getUShort(int);

	void setBooleanValue(int, bool);
	void setByte(int, int);
	void setCString(int, char*);
	void setCStringAsString(int, string);
	void setDoubleValue(int, double);
	void setLong(int, int);
	void setPString(int, char*);
	void setPStringAsCString(int, char*);
	void setPStringAsString(int, string);
	void setShort(int, int);
	void setSingleValue(int, double);
	void setStringValue(int, int, char*);
	void setStringValueAsCString(int, int, char*);
	void setStringValueAsString(int, int, string);
	void setUShort(int, int);

	/* C++-LIKE GET/SET FUNCTIONS */
	bool getBool(int);
	char getChar(int);
	signed char getSignedChar(int);
	int getInt(int);
	short int getShortInt(int);
	long int getLongInt(int);
	unsigned short int getUnsignedShortInt(int);
	unsigned long int getUnsignedLongInt(int);
	float getFloat(int);
	double getDouble(int);
	long double getLongDouble(int);
	wchar_t getWchar_t(int);
	string getString(int);
	char * getCharStar(int);

	void setBool(int, bool);
	void setChar(int, char);
	void setSignedChar(int, signed char);
	void setInt(int, int);
	void setShortInt(int, short int);
	void setLongInt(int, long int);
	void setUnsignedShortInt(int, unsigned short int);
	void setUnsignedLongInt(int, unsigned long int);
	void setFloat(int, float);
	void setDouble(int, double);
	void setLongDouble(int, long double);
	void setWchar_t(int, wchar_t);
	void setString(int, string);
	void setCharStar(int, char *);

	private:

	char * mydata;
	int mysize;

	int min(int, int);
	int max(int, int);

	void clear(void);
};

inline int memoryblock::min(int x, int y)
{
	return (x>y)?y:x;
}

inline int memoryblock::max(int x, int y)
{
	return (x>y)?x:y;
}

inline void memoryblock::setLittleEndian(void)
{
	littleEndian = true;
}

inline void memoryblock::setBigEndian(void)
{
	littleEndian = false;
}

inline void memoryblock::setMotorola(void)
{
	littleEndian = false;
}

inline void memoryblock::setIntel(void)
{
	littleEndian = true;
}

#endif
